package com.example.sefinsa_app;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.work.WorkManager;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ConfiguracionSemanasController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.ConfiguracionSemana;
import com.example.sefinsa_app.models.Empleado;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NetworkChangeListener;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.Executors;

import io.github.douglasjunior.androidSimpleTooltip.BuildConfig;

public class LoginActivity extends AppCompatActivity {

    private Button btnLogin;
    private TextInputLayout tlUsuario, tlContrasenia;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private SharedPreferences sesion;
    private ConfiguracionSemanasController configuracionSemanaController;
    private ArrayList<ConfiguracionSemana> configuracionSemanas;
    private TextView tvAnio, tvVersion;

    private final int CODIGO_PERMISOS= 777;

    NetworkChangeListener networkChangeListener = new NetworkChangeListener();

    @SuppressLint("SetTextI18n")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Locale.setDefault(Locale.US);
        setContentView(R.layout.activity_login);
        Executors.newSingleThreadExecutor().execute(() -> {
            WorkManager workManager = WorkManager.getInstance(LoginActivity.this);

            workManager.cancelAllWork();

            WorkManager.getInstance(LoginActivity.this).cancelAllWork();
            LoginActivity.this.deleteDatabase("workmanager.db");

            getConfiguracionSemana();
        });
        if(!API.production){
            Toast.makeText(this, "Modo de pruebas", Toast.LENGTH_LONG).show();
        }
        sesion = getSharedPreferences("sesion", Context.MODE_PRIVATE);
        btnLogin = findViewById(R.id.btnLogin);
        tlUsuario = findViewById(R.id.tlUsuario);
        tlContrasenia = findViewById(R.id.tlContrasenia);
        tvAnio = findViewById(R.id.tvAnio);
        tvVersion = findViewById(R.id.tvVersion);

        tvAnio.setText(String.valueOf(Calendar.getInstance().get(Calendar.YEAR)));
        tvVersion.setText("v " + "2.0.1");

        int permisoAlmacen = ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE);
        int permisoAlmacen2 = ContextCompat.checkSelfPermission(this, Manifest.permission.READ_EXTERNAL_STORAGE);
        int permisoCamara = ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA);
        int permisoBT1 = ContextCompat.checkSelfPermission(this, Manifest.permission.BLUETOOTH_CONNECT);
        int permisoBT2 = ContextCompat.checkSelfPermission(this, Manifest.permission.BLUETOOTH);
        int permisoUbicacion1 = ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION);
        int permisoUbicacion2 = ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION);

        if (permisoAlmacen == PackageManager.PERMISSION_GRANTED
                && permisoAlmacen2 == PackageManager.PERMISSION_GRANTED
                && permisoCamara == PackageManager.PERMISSION_GRANTED
                && permisoBT1 == PackageManager.PERMISSION_GRANTED
                && permisoBT2 == PackageManager.PERMISSION_GRANTED
                && permisoUbicacion1 == PackageManager.PERMISSION_GRANTED
                && permisoUbicacion2 == PackageManager.PERMISSION_GRANTED) {
        } else {
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE,
                            Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.BLUETOOTH,
                            Manifest.permission.BLUETOOTH_CONNECT, Manifest.permission.ACCESS_FINE_LOCATION,
                            Manifest.permission.ACCESS_COARSE_LOCATION},
                    CODIGO_PERMISOS);
        }

        btnLogin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Executors.newSingleThreadExecutor().execute(() -> {
                    runOnUiThread(() -> {
                        if (Validator.fieldValidation(tlUsuario, "Ingresa un usuario válido") &&
                                Validator.fieldValidation(tlContrasenia, "Ingresa una contraseña válida")) {
                            login(tlUsuario.getEditText().getText().toString(), tlContrasenia.getEditText().getText().toString());
                        }
                    });
                });
            }
        });
    }

    @Override
    public void onStart() {
        IntentFilter intentFilter = new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION);
        registerReceiver(networkChangeListener, intentFilter);
        super.onStart();
    }

    @Override
    public void onStop() {
        unregisterReceiver(networkChangeListener);
        super.onStop();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case CODIGO_PERMISOS:
                if (grantResults.length > 0) {
                    if(grantResults[0] != PackageManager.PERMISSION_GRANTED ||
                            grantResults[1] != PackageManager.PERMISSION_GRANTED ||
                            grantResults[2] != PackageManager.PERMISSION_GRANTED ||
                            grantResults[5] != PackageManager.PERMISSION_GRANTED ||
                            grantResults[6] != PackageManager.PERMISSION_GRANTED){
                        //finish();
                        //Toast.makeText(this, "Es necesario otorgar todos los permisos", Toast.LENGTH_SHORT).show();
                        showPermissionDeniedDialog();
                    }

                } else {
                    //finish();
                    //Toast.makeText(this, "Es necesario otorgar todos los permisos", Toast.LENGTH_SHORT).show();
                    showPermissionDeniedDialog();
                }
                break;
        }
    }
    private void showPermissionDeniedDialog() {
        if (!isFinishing()) {
            AlertDialog.Builder builder = new AlertDialog.Builder(this);
            builder.setTitle("Permisos necesarios");
            builder.setMessage("Los permisos son necesarios para el correcto funcionamiento de la aplicación. Por favor, otorgue los permisos requeridos.");
            builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // Solicitar permisos nuevamente
                    ActivityCompat.requestPermissions(LoginActivity.this,
                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE,
                                    Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.BLUETOOTH,
                                    Manifest.permission.BLUETOOTH_CONNECT, Manifest.permission.ACCESS_FINE_LOCATION,
                                    Manifest.permission.ACCESS_COARSE_LOCATION},
                            CODIGO_PERMISOS);
                }
            });
            builder.setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // El usuario canceló la solicitud de permisos
                    Toast.makeText(LoginActivity.this, "Los permisos son necesarios para utilizar la aplicación.", Toast.LENGTH_SHORT).show();
                }
            });
            builder.setCancelable(false); // Evitar que el diálogo se cierre al tocar fuera de él
            builder.show();
        }
    }

    private void login(String usuario, String contrasenia)
    {
        AlertDialog.Builder builder = new AlertDialog.Builder(LoginActivity.this);
        LayoutInflater inflater = getLayoutInflater();
        View dialogView = inflater.inflate(R.layout.dialog_progress, null);
        builder.setView(dialogView);
        builder.setCancelable(false);

        AlertDialog dialog = builder.create();
        dialog.show();

        vs = VolleyS.getInstance(this.getApplicationContext());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("usuario", usuario);
            data.put("password", contrasenia);
            data.put("func", "login");

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlEmpleados, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            dialog.cancel();

                            Log.d("response", response.toString());

                            Gson gson = new Gson();
                            Empleado empleado = null;

                            // Verificar si "data" es un JSONObject o JSONArray
                            Object dataRaw = response.get("data");

                            if (dataRaw instanceof JSONArray) {
                                JSONArray dataArray = (JSONArray) dataRaw;
                                Log.d("dataType", "JSONArray");

                                if (dataArray.length() > 0) {
                                    JSONObject dataObject = dataArray.getJSONObject(0);
                                    empleado = gson.fromJson(dataObject.toString(), Empleado.class);
                                } else {
                                    Toast.makeText(LoginActivity.this, "No se encontraron datos de usuario", Toast.LENGTH_SHORT).show();
                                    return;
                                }
                            } else if (dataRaw instanceof JSONObject) {
                                JSONObject dataObject = (JSONObject) dataRaw;
                                Log.d("dataType", "JSONObject");
                                empleado = gson.fromJson(dataObject.toString(), Empleado.class);
                            } else {
                                Toast.makeText(LoginActivity.this, "Respuesta inesperada del servidor", Toast.LENGTH_SHORT).show();
                                return;
                            }

                            if (empleado != null) {
                                // Obtener el ID del empleado en caché
                                String cachedId = sesion.getString("id", null);

                                // Si hay un ID en caché y no coincide, limpiar los datos locales
                                if (cachedId != null && !cachedId.equals(empleado.id)) {
                                    clearLocalData();
                                }

                                // Guardar el nuevo ID del empleado en caché
                                SharedPreferences.Editor editor = sesion.edit();
                                editor.putString("id", empleado.id);
                                editor.putString("nombre", empleado.nombre_completo);
                                editor.putString("usuario", empleado.usuario);
                                editor.putString("perfil_id", empleado.perfil_id);
                                editor.putString("tipo_perfil", empleado.tipo_perfil);
                                editor.putString("nombre_perfil", empleado.nombre_perfil);
                                editor.putString("rutas", empleado.rutas);
                                editor.putString("telefono", empleado.telefono);
                                editor.commit();

                                // Ir al Dashboard
                                Intent intent = new Intent(LoginActivity.this, DashboardActivity.class);
                                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
                                startActivity(intent);
                                finish();
                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                            Toast.makeText(LoginActivity.this, "Error al procesar la respuesta del servidor", Toast.LENGTH_SHORT).show();
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        dialog.cancel();
                        Log.d("loginError", error.toString());
                        ErrorChecker.checker(error, LoginActivity.this);
                    }
                }
        );

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);

    }

    private void clearLocalData() {
        DatabaseHelper dbHelper = new DatabaseHelper(getApplicationContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Borra los datos de las tablas
        //db.delete("avales", null, null);
        db.delete("clientes", null, null);
        db.delete("prestamos", null, null);
        db.delete("pagos", null, null);

        db.close();
        Log.d("SQLite", "Datos locales eliminados correctamente de CLIENTES, PRESTAMOS Y PAGOS.");
    }


    public void getConfiguracionSemana() {
        Log.d("DEBUG", "Entro en getConfiguracionSemana()............");
        configuracionSemanaController = new ConfiguracionSemanasController(LoginActivity.this);
        configuracionSemanas = new ArrayList<ConfiguracionSemana>();
        // Comprobar si el tamaño de configuracionSemanaController es mayor o igual a 0
        if (configuracionSemanaController.obtener().size() == 0) {
            Log.d("DEBUG", "Entro en configuracionSemanaController().size() == 0............");

            vs = VolleyS.getInstance(LoginActivity.this);
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "indexApp_UpdConfiguraciones");
                //Log.d("DEBUG", "Datos a enviar: " + data.toString()); // Log para verificar los datos a enviar

            } catch (JSONException e) {
                Log.d("DEBUG", "Error al crear el JSON: " + e.getMessage());
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                //Log.d("DEBUG", "Entro en request SUCCESS............");
                                JSONArray data = response.getJSONArray("data"); // Cambié esto por getJSONArray()

                                //Log.d("DEBUG", "Tamaño de datos recibidos: " + data.length()); // Log para verificar el tamaño de los datos

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    //Log.d("DEBUG", "Objeto recibido: " + obj.toString()); // Log para verificar el objeto recibido

                                    Gson gson = new Gson();
                                    ConfiguracionSemana configuracion = gson.fromJson(obj.toString(), ConfiguracionSemana.class);
                                    configuracionSemanas.add(configuracion);
                                    configuracionSemanaController.nueva(configuracion);
                                }
                            } catch (JSONException e) {
                                Log.d("DEBUG", "Error en el procesamiento de la respuesta: " + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.d("DEBUG", "Entro en request ERROR getConfiguracionSemana!!!!!............");

                    // Verifica si hay una respuesta del servidor
                    if (error.networkResponse != null) {
                        // Aquí puedes obtener el código de estado HTTP
                        int statusCode = error.networkResponse.statusCode;
                        Log.d("DEBUG", "HTTP Status Code: " + statusCode);

                        // También puedes intentar obtener el cuerpo de la respuesta
                        String responseBody = new String(error.networkResponse.data);
                        Log.d("DEBUG", "Response Body: " + responseBody);
                    } else {
                        Log.d("DEBUG", "No hay respuesta del servidor.");
                    }

                    ErrorChecker.checker(error, LoginActivity.this);
                }

            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            Log.d("DEBUG", "No hay configuraciones disponibles en configuracionSemanaController.");
        }
    }
}